//*****************************************************************************
//
// hw_lis3dsh.h - Macros used when accessing the ST LIS3DSH accelerometer
//
// * THis provides an interface to access accelerometer data from the LIS3DSH.

// * This code is modified from hw_lsm303dlhc.h that is provided as part of
// * revision 1.1 of the Tiva Firmware Development Package, from Texas Instruments Incorporated.
// *
// * Written by Dale Tardiff, Innovative Power Solutions Inc.
// * Version 0.1 - Started Jan 31, 2014
//
//*****************************************************************************

#ifndef __SENSORLIB_HW_LIS3DSH_H__
#define __SENSORLIB_HW_LIS3DSH_H__

//*****************************************************************************
//
// The following are defines for the LIS3DSH register addresses
//
//*****************************************************************************
#define LIS3DSH_INFO1    0x0D         // Information register 1
#define LIS3DSH_INFO2    0x0E        // Information register 1
#define LIS3DSH_WHO_AM_I    0x0F       // ID Register
#define LIS3DSH_CTRL_REG3   0x23       // Control Register
#define LIS3DSH_CTRL_REG4   0x20       // Control Register
#define LIS3DSH_CTRL_REG5   0x24       // Control Register
#define LIS3DSH_CTRL_REG6   0x25       // Control Register
#define LIS3DSH_STATUS      0x27       // Status Data Register
#define LIS3DSH_OUT_T       0x0C       // Temperature Output
#define LIS3DSH_OFF_X 		0x10		//X-axis offset correction
#define LIS3DSH_OFF_Y 		0x11 		//Y-axis offset correction
#define LIS3DSH_OFF_Z 	 	0x12 		//Z-axis offset correction
#define LIS3DSH_CS_X	    0x13 		//Constant shift X
#define LIS3DSH_CS_Y 		0x14 		//Constant shift Y
#define LIS3DSH_CS_Z 		0x15 		//Constant shift Z
#define LIS3DSH_LC_L 		0x16 		//Long Counter Register
#define LIS3DSH_LC_H 		0x17		//Long Counter Register
#define LIS3DSH_STAT 		0x18 		//Interrupt synchronization
#define LIS3DSH_VFC_1 		0x1B 		//Vector filter coefficient 1
#define LIS3DSH_VFC_2 		0x1C 		//Vector filter coefficient 2
#define LIS3DSH_VFC_3 		0x1D 		//Vector filter coefficient 3
#define LIS3DSH_VFC_4 		0x1E 		//Vector filter coefficient 4
#define LIS3DSH_THRS3 		0x1F 		//Threshold value 3
#define LIS3DSH_OUT_X_L 	0x28		//Output XL
#define LIS3DSH_OUT_X_H 	0x29		//Output XH
#define LIS3DSH_OUT_Y_L 	0x2A		//Output YL
#define LIS3DSH_OUT_Y_H 	0x2B		//Output YH
#define LIS3DSH_OUT_Z_L 	0x2C		//Output ZL
#define LIS3DSH_OUT_Z_H 	0x2D		//Output ZH
#define LIS3DSH_FIFO_CTRL  	0x2E        // FIFO control
#define LIS3DSH_FIFO_SRC   	0x2F        // FIFO_SRC register
#define LIS3DSH_CTRL_REG1 	0x21 		//SM1 control register
#define LIS3DSH_ST1_1 		0x40		//SM1 Code Register 1
#define LIS3DSH_ST1_2 		0x41		//SM1 Code Register 2
#define LIS3DSH_ST1_3 		0x42		//SM1 Code Register 3
#define LIS3DSH_ST1_4 		0x43		//SM1 Code Register 4
#define LIS3DSH_ST1_5 		0x44		//SM1 Code Register 5
#define LIS3DSH_ST1_6 		0x45		//SM1 Code Register 6
#define LIS3DSH_ST1_7 		0x46		//SM1 Code Register 7
#define LIS3DSH_ST1_8 		0x47		//SM1 Code Register 8
#define LIS3DSH_ST1_9 		0x48		//SM1 Code Register 9
#define LIS3DSH_ST1_10 		0x49		//SM1 Code Register 10
#define LIS3DSH_ST1_11		0x4A		//SM1 Code Register 11
#define LIS3DSH_ST1_12		0x4B		//SM1 Code Register 12
#define LIS3DSH_ST1_13		0x4C		//SM1 Code Register 13
#define LIS3DSH_ST1_14		0x4D		//SM1 Code Register 14
#define LIS3DSH_ST1_15		0x4E		//SM1 Code Register 15
#define LIS3DSH_ST1_16 		0x4F		//SM1 Code Register 16
#define LIS3DSH_TIM4_1 		0x50    	//SM1 General Timer
#define LIS3DSH_TIM3_1 		0x51    	//SM1 General Timer
#define LIS3DSH_TIM2_1_L	0x52    	//SM1 General Timer
#define LIS3DSH_TIM2_1_H	0x53    	//SM1 General Timer
#define LIS3DSH_TIM1_1_L	0x54    	//SM1 General Timer
#define LIS3DSH_TIM1_1_H	0x55    	//SM1 General Timer
#define LIS3DSH_THRS2_1 	0x56 		//SM1 threshold value 1
#define LIS3DSH_THRS1_1 	0x57 		//SM1 threshold value 2
#define LIS3DSH_MASK1_B 	0x59 		//SM1 axis and sign mask
#define LIS3DSH_MASK1_A 	0x5A 		//SM1 axis and sign mask
#define LIS3DSH_SETT1 		0x5B 		//SM1 detection settings
#define LIS3DSH_PR1 		0x5C 		//Program-reset pointer
#define LIS3DSH_TC1_L		0x5D 		//Timer Counter
#define LIS3DSH_TC1_H		0x5E 		//Timer Counter
#define LIS3DSH_OUTS1 		0x5F 		//Main set flag
#define LIS3DSH_PEAK1 		0x19 		//Peak value

#define LIS3DSH_CTRL_REG2 	0x22 		//SM2 control register
#define LIS3DSH_ST2_1 		0x60		//SM2 Code Register 1
#define LIS3DSH_ST2_2 		0x61		//SM2 Code Register 2
#define LIS3DSH_ST2_3 		0x62		//SM2 Code Register 3
#define LIS3DSH_ST2_4 		0x63		//SM2 Code Register 4
#define LIS3DSH_ST2_5 		0x64		//SM2 Code Register 5
#define LIS3DSH_ST2_6 		0x65		//SM2 Code Register 6
#define LIS3DSH_ST2_7 		0x66		//SM2 Code Register 7
#define LIS3DSH_ST2_8 		0x67		//SM2 Code Register 8
#define LIS3DSH_ST2_9 		0x68		//SM2 Code Register 9
#define LIS3DSH_ST2_10 		0x69		//SM2 Code Register 10
#define LIS3DSH_ST2_11		0x6A		//SM2 Code Register 11
#define LIS3DSH_ST2_12		0x6B		//SM2 Code Register 12
#define LIS3DSH_ST2_13		0x6C		//SM2 Code Register 13
#define LIS3DSH_ST2_14		0x6D		//SM2 Code Register 14
#define LIS3DSH_ST2_15		0x6E		//SM2 Code Register 15
#define LIS3DSH_ST2_16 		0x6F		//SM2 Code Register 16
#define LIS3DSH_TIM4_2 		0x70    	//SM2 General Timer
#define LIS3DSH_TIM3_2 		0x71    	//SM2 General Timer
#define LIS3DSH_TIM2_2_L	0x72    	//SM2 General Timer
#define LIS3DSH_TIM2_2_H	0x73    	//SM2 General Timer
#define LIS3DSH_TIM1_2_L	0x74    	//SM2 General Timer
#define LIS3DSH_TIM1_2_H	0x75    	//SM2 General Timer
#define LIS3DSH_THRS2_2 	0x76 		//SM2 threshold value 1
#define LIS3DSH_THRS1_2 	0x77 		//SM2 threshold value 2
#define LIS3DSH_MASK2_B 	0x79 		//SM2 axis and sign mask
#define LIS3DSH_MASK2_A 	0x7A 		//SM2 axis and sign mask
#define LIS3DSH_SETT2 		0x7B 		//SM2 detection settings
#define LIS3DSH_PR2 		0x7C 		//Program-reset pointer
#define LIS3DSH_TC2_L		0x7D 		//Timer Counter
#define LIS3DSH_TC2_H		0x7E 		//Timer Counter
#define LIS3DSH_OUTS2 		0x7F 		//Main set flag
#define LIS3DSH_PEAK2 		0x1A 		//Peak value
#define LIS3DSH_DES2 		0x78 		//Decimation factor

//*****************************************************************************
//
// The following are defines for the bit fields in the LIS3DSH_CTRL_REG3
// register.
//
//*****************************************************************************
#define LIS3DSH_CTRL_REG3_DR_EN                                             \
                                0x80        // DRDY signal enable to INT1
#define LIS3DSH_CTRL_REG3_DR_EN_DIS                                           \
                                0x00
#define LIS3DSH_CTRL_REG3_DR_EN_CON                                            \
                                0x80
#define LIS3DSH_CTRL_REG3_IEA 	0x40        // Interrupt signal polarity
#define LIS3DSH_CTRL_REG3_IEL   0x20        // Interrupt signal latching [0 = latched, 1 = pulsed]

#define LIS3DSH_CTRL_REG3_INT2_EN                                           \
                                0x10        // INT2 enable/disable [0 = disabled]
#define LIS3DSH_CTRL_REG3_INT1_EN                                           \
                                0x08        // INT2 enable/disable [0 = disabled]
#define LIS3DSH_CTRL_REG3_VFILT                                           \
                                0x04        // Vector filter enable/disable [0 = disabled]
#define LIS3DSH_CTRL_REG3_STRT                                            \
                                0x01        // Soft reset bit [0 = no soft reset]

//*****************************************************************************
//
// The following are defines for the bit fields in the LIS3DSH_CTRL_REG4
// register.
//
//*****************************************************************************
#define LIS3DSH_CTRL_REG4_ODR   0xF0        // Output data rate and power mode selection. Default value:0000
#define LIS3DSH_CTRL_REG4_BDU   0x08        // Block data update. Default value:0
#define LIS3DSH_CTRL_REG4_ZEN   0x04        // Z axis enable. Default value:1 [enabled]
#define LIS3DSH_CTRL_REG4_YEN   0x02        // Y axis enable. Default value:1 [enabled]
#define LIS3DSH_CTRL_REG4_XEN   0x01        // X axis enable. Default value:1 [enabled]
#define LIS3DSH_CTRL_REG4_ODR_NONE                                      \
                                0x00        // power down
#define LIS3DSH_CTRL_REG4_ODR_3HZ                                      \
                                0x10        // 3.125 Hz
#define LIS3DSH_CTRL_REG4_ODR_6HZ                                      \
                                0x20        // 6.25 Hz
#define LIS3DSH_CTRL_REG4_ODR_12HZ                                      \
                                0x30        // 12.5 Hz
#define LIS3DSH_CTRL_REG4_ODR_25HZ                                      \
                                0x40        // 25 Hz
#define LIS3DSH_CTRL_REG4_ODR_50HZ                                      \
                                0x50        // 50 Hz
#define LIS3DSH_CTRL_REG4_ODR_100HZ                                      \
                                0x60        // 100 Hz
#define LIS3DSH_CTRL_REG4_ODR_400HZ                                      \
                                0x70        // 400 Hz
#define LIS3DSH_CTRL_REG4_ODR_800HZ                                      \
                                0x80        // 800 Hz
#define LIS3DSH_CTRL_REG4_ODR_1600HZ                                      \
                                0x90        // 1600 Hz

//*****************************************************************************
//
// The following are defines for the bit fields in the LIS3DSH_CTRL_REG5
// register.
//
//*****************************************************************************
#define LIS3DSH_CTRL_REG5_BW    0xC0         //Anti-aliasing filter bandwidth. Default value: 00
#define LIS3DSH_CTRL_REG5_BW_800HZ                                     \
                                0x00        // BW = 800 Hz
#define LIS3DSH_CTRL_REG5_BW_400HZ                                     \
                                0x40        // BW = 400 Hz
#define LIS3DSH_CTRL_REG5_BW_200HZ                                     \
                                0x80        // BW = 200 Hz
#define LIS3DSH_CTRL_REG5_BW_50HZ                                     \
                                0xC0        // BW = 50 Hz

#define LIS3DSH_CTRL_REG5_FSCALE                                         \
                                0x38        // Full-scale selection. Default value: 00
#define LIS3DSH_CTRL_REG5_FSCALE_2G                                         \
                                0x00        // Full-scale +/- 2G
#define LIS3DSH_CTRL_REG5_FSCALE_4G                                         \
                                0x08        // Full-scale +/- 4G
#define LIS3DSH_CTRL_REG5_FSCALE_6G                                         \
                                0x10        // Full-scale +/- 6G
#define LIS3DSH_CTRL_REG5_FSCALE_8G                                         \
                                0x18        // Full-scale +/- 8G
#define LIS3DSH_CTRL_REG5_FSCALE_16G                                         \
                                0x20        // Full-scale +/- 16G
#define LIS3DSH_CTRL_REG5_ST    0x06        // Self-test enable. Default value: 00
#define LIS3DSH_CTRL_REG5_ST_NORMAL                                         \
                                0x00        // Normal mode
#define LIS3DSH_CTRL_REG5_ST_POS                                         \
                                0x20        // Positive sign self-test
#define LIS3DSH_CTRL_REG5_ST_NEG                                         \
                                0x40        // Negative sign self-test
#define LIS3DSH_CTRL_REG5_SIM   0x01		// SPI serial interface mode selection. Default value: 0 [4 wire]
#define LIS3DSH_CTRL_REG5_SIM_3WIRE   0x01		// SPI serial interface mode selection. [3 wire]

//*****************************************************************************
//
// The following are defines for the bit fields in the LIS3DSH_CTRL_REG6
// register.
//
//*****************************************************************************
#define LIS3DSH_CTRL_REG6_BOOT  0x80        // Force reboot, cleared as soon as
                                            // the reboot is finished. Active high.
#define LIS3DSH_CTRL_REG6_FIFO_EN                                         \
                                0x40		// FIFO enable. Default value 0.
#define LIS3DSH_CTRL_REG6_WTM_EN                                              \
                                0x20        // Enable FIFO Watermark level use. Default value 0.
#define LIS3DSH_CTRL_REG6_ADD_INC                                           \
                                0x10		// Register address automatically incremented
											// during a multiple byte access with a
											// serial interface (I2C or SPI).
#define LIS3DSH_CTRL_REG6_P1_EMPTY                                              \
                                0x08        // Enable FIFO Empty indication on int1. Default value 0.
#define LIS3DSH_CTRL_REG6_P1_WTM                                              \
                                0x04        // FIFO Watermark interrupt on int1. Default value 0.
#define LIS3DSH_CTRL_REG6_P1_OVERRUN                                              \
                                0x02        // FIFO overrun interrupt on int1. Default value 0.
#define LIS3DSH_CTRL_REG6_P2_BOOT                                              \
                                0x01        // BOOT interrupt on int2. Default value 0.


//*****************************************************************************
//
// The following are defines for the bit fields in the LIS3DSH_O_STATUS
// register.
//
//*****************************************************************************
#define LIS3DSH_STATUS_ZYXOR   0x80			// X, Y, and Z axis data overrun. Default value: 0
#define LIS3DSH_STATUS_ZOR	   0x40			// Z axis data overrun. Default value: 0
#define LIS3DSH_STATUS_YOR	   0x20			// Y axis data overrun. Default value: 0
#define LIS3DSH_STATUS_XOR     0x10			// Z axis data overrun. Default value: 0
#define LIS3DSH_STATUS_ZYXDA   0x08			// X, Y, and Z axis new data available. Default value: 0
#define LIS3DSH_STATUS_ZDA     0x04			// Z axis new data available. Default value: 0
#define LIS3DSH_STATUS_YDA     0x02			// Y axis new data available. Default value: 0
#define LIS3DSH_STATUS_XDA     0x01			// X axis new data available. Default value: 0

//*****************************************************************************
//
// The following are defines for the bit fields in the LIS3DSH_O_STAT
// register.
//
//*****************************************************************************
#define LIS3DSH_STAT_LONG		0x80		// 0=no interrupt, 1=long counter (LC) interrupt flag common for both SM
#define LIS3DSH_STAT_SYNCW	    0x40		// Synchronization for external Host Controller interrupt based on output data
#define LIS3DSH_STAT_SYNC1		0x20		// 0=SM1 running normally, 1=SM1 stopped and await restart request from SM2
#define LIS3DSH_STAT_SYNC2		0x10		// 0=SM2 running normally, 1=SM2 stopped and await restart request from SM1
#define LIS3DSH_STAT_INT_SM1	0x08		// SM1 - Interrupt Selection - 1=SM1 interrupt enable; 0: SM1 interrupt disable
#define LIS3DSH_STAT_INT_SM2	0x04		// SM2 - Interrupt Selection - 1=SM2 interrupt enable; 0: SM2 interrupt disable
#define LIS3DSH_STAT_DOR		0x02		// Data overrun indicates not read data from output register when next data samples
											// measure start; 0=no overrun, 1=data overrun data overrun bit is reset when next
											// sample is ready
#define LIS3DSH_STAT_DRDY		0x01		// data ready from output register

//*****************************************************************************
//
// The following are defines for the bit fields in the LIS3DSH_FIFO_CTRL
// register.
//
//*****************************************************************************
#define LIS3DSH_FIFO_CTRL_FMODE 0xE0         //FIFO Mode Selection
#define LIS3DSH_FIFO_CTRL_FMODE_BYPASS                                     \
                                0x00        // Bypass Mode. FIFO turned off
#define LIS3DSH_FIFO_CTRL_FMODE_FIFO                                     \
                                0x20        // FIFO Mode. Stop collecting data
											// when FIFO is full
#define LIS3DSH_FIFO_CTRL_FMODE_STREAM                                     \
                                0x60        // Stream Mode. If the FIFO is full
											// the new sample overwrites the
											// older one
#define LIS3DSH_FIFO_CTRL_FMODE_MIX1                                     \
                                0xA0        // Stream mode until trigger is deasserted,
											// then FIFO mode
#define LIS3DSH_FIFO_CTRL_FMODE_MIX2                                         \
                                0xE0        // Bypass mode until trigger is deasserted,
											// then Stream mode
#define LIS3DSH_FIFO_CTRL_WTMP  0x1F        // FIFO Watermark pointer; FIFO deep if the Watermark is enabled.
#define LIS3DSH_FIFO_CTRL_WTMP4                                         \
                                0x10        // FIFO Watermark pointer; FIFO deep if the Watermark is enabled.
#define LIS3DSH_FIFO_CTRL_WTMP3                                         \
                                0x08
#define LIS3DSH_FIFO_CTRL_WTMP2                                         \
                                0x04
#define LIS3DSH_FIFO_CTRL_WTMP1                                         \
                                0x02
#define LIS3DSH_FIFO_CTRL_WTMP0                                         \
                                0x01
//*****************************************************************************
//
// The following are defines for the bit fields in the LIS3DSH_FIFO_SRC
// register.
//
//*****************************************************************************
#define LIS3DSH_FIFO_SRC_WTM    0x80        // Watermark status.
                                			// 0=FIFO filling is lower than WTM level; 1=FIFO filling is equal or
                                			//higher than WTM level
#define LIS3DSH_FIFO_SRC_OVRN_FIFO                                     \
                                0x40        // Overrun bit status. 0=FIFO is not completely filled;
											// 1=FIFO is completely filled
#define LIS3DSH_FIFO_SRC_EMPTY  0x20        // FIFO empty bit.
                                			// 0=FIFO not empty; 1=FIFO empty)
#define LIS3DSH_FIFO_SRC_FMODE_FSS                                     \
                                0x1F        // FIFO stored data level

//*****************************************************************************
//
// The following are defines for the bit fields in the LIS3DSH_CTRL_REG1
// register.
//
//*****************************************************************************
#define LIS3DSH_CTRL_REG1_HYSTx_1                                         \
								0xE0		// Hysteresis unsigned value to be added or
                                			// subtracted from threshold value in SM1
#define LIS3DSH_CTRL_REG1_SM1_PIN                                              \
								0x08        // 0=SM1 interrupt routed to INT1, 1=SM1 interrupt routed to INT2 pin
                                			// Default value=0
#define LIS3DSH_CTRL_REG1_SM1_EN                                           \
								0x01		// 0=SM1 disabled, 1=SM1 enabled
                                			// Default value=0



#endif // __SENSORLIB_HW_LIS3DSH_H__
